//
// Toroid.js
//  inspired by Grapher
//
//  v.061020
//  required version : Cheetah3D v3.4
//
//  (c) 2006 Hiroto Tsubaki
//  http://www.tres-graficos.jp/
//  tg@tres-graficos.jp
//
// 2006-10-20 fix calculation bug. (thanks Martin.)

var normalType;
var normalAngle;

function buildUI(obj) {
    
    obj.setParameter("name","Conchoid");
    
    obj.addParameterInt("sections tube",5,3,180,true,true);
    obj.addParameterInt("sections",50,5,1000,true,true);
    obj.addParameterFloat("spiral count",6,0,100,true,true);
    
    obj.addParameterSeparator("variables");
    obj.addParameterFloat("k",1.2,-1000,1000,true,true);
    obj.addParameterFloat("k2",1.2,-1000,1000,true,true);
    obj.addParameterFloat("a",1.5,-1000,1000,true,true);    
    
    obj.addParameterSeparator("Smooth");
    obj.addParameterInt("smooth type", 2,0,2,true,true);
    obj.addParameterFloat("smooth angle", 45.0, 5.0, 90.0, true, true);
    obj.addParameterButton("set smooth","Set","setSmooth");
    
    setSmooth(obj);       
}

function setSmooth(obj) {
    normalType = obj.getParameter("smooth type");
    normalAngle = obj.getParameter("smooth angle");
    
    obj.setParameter("normalType",normalType);
    obj.setParameter("normalAngle",normalAngle);
}

function buildObject(obj) {
    var i,j,k;
    var core = obj.core();
    var step = obj.getParameter("sections tube");
    var section = obj.getParameter("sections");
    var sr = obj.getParameter("spiral count");
    var k = obj.getParameter("k");
    var k2 = obj.getParameter("k2");
    var a = obj.getParameter("a");
    
    for (i = 0;i < section;i++) {
        var ang_i = Math.PI*sr/section*i;
        for (j = 0;j < step;j++) {
            var ang_j = Math.PI*2.0/step*j;
            var vert = new Vec3D(
                    Math.pow(k,ang_i)*(1+Math.cos(ang_j))*Math.cos(ang_i),
                    Math.pow(k,ang_i)*(1+Math.cos(ang_j))*Math.sin(ang_i),
                    Math.pow(k,ang_i)*Math.sin(ang_j)-a*Math.pow(k2,ang_i));
            core.addVertex(false,vert);
        }
    }
    
    for (i = 0;i < section - 1;i++) {
        k = i * step;
        //print(i);
        for (j = 0;j < step;j++) {
            if (j == step -1) {
                var poly = [k+j,k+j-step+1,k+j+1,k+j+step];
            } else {
                var poly = [k+j,k+j+1,k+j+step+1,k+j+step];
            }
            //print(poly);
            var uvs = [
                new Vec2D(1/step*j,1/section*i),
                new Vec2D(1/step*(j+1),1/section*i),
                new Vec2D(1/step*(j+1),1/section*(i+1)),
                new Vec2D(1/step*j,1/section*(i+1))
                ];
            core.addIndexPolygon(4,poly,uvs);
        }
    }
}

